﻿#include  "StdAfx.h"

#include  "ArchiveFolder.hpp"
#include  "ArchiveCategoryProvider.hpp"
#include  "ArchiveVolumeInfo.hpp"
#include  "FolderEnumIDList.hpp"
#include  "Pidl.hpp"
#include  <szPath.hpp>
#include  <strsafe.h>

using namespace szpp;

CArchiveFolder::CArchiveFolder() : m_ThisPidl(0), m_RootPidl(0), m_ThisPath(), m_RootPath(), m_VolumeInfo(), m_Container(0)
{
  ATLTRACE2(atlTraceGeneral, 0, SZL("CArchiveFolder::CArchiveFolder()\n"));
}

CArchiveFolder::~CArchiveFolder()
{
  if (0 != m_ThisPidl)
    CoTaskMemFree((LPVOID)m_ThisPidl);

  if (0 != m_RootPidl)
    CoTaskMemFree((LPVOID)m_RootPidl);
}

// IPersist::GetClassID
STDMETHODIMP CArchiveFolder::GetClassID(__out CLSID *pClassID)
{
  if (NULL == pClassID)
    return E_POINTER;

  *pClassID = CLSID_ArchiveFolder;
  return S_OK;
}

// IPersistFolder::Initialize
STDMETHODIMP CArchiveFolder::Initialize(__in PCIDLIST_ABSOLUTE pidl)
{
  // フォルダオブジェクトは必ずルートオブジェクト（アーカイブ）

  if (0 == pidl)
    return E_INVALIDARG;

  if (0 != m_RootPidl)
  {
    if (ILIsEqual(pidl, m_RootPidl))
      return S_OK;
    CoTaskMemFree((LPVOID)m_RootPidl);
  }

  m_ThisPath.clear();
  m_ThisPidl = 0;

  // アーカイブの格納アイテムの列挙
  m_RootPidl = ILClone(pidl);
  if (0 != m_RootPidl)
  {
    szchar szPath[MAX_PATH];
    if (FALSE == SHGetPathFromIDList(m_RootPidl, szPath))
      return E_FAIL;

    m_RootPath.assign(szPath);

    try
    {
      m_VolumeInfo.reset(new ArchiveVolumeInfo(m_RootPath));
      m_Container = 0;
      return S_OK;
    }
    catch (...)
    {
    }
  }

  return E_FAIL;
}

// IPersistFolder2::GetCurFolder
STDMETHODIMP CArchiveFolder::GetCurFolder(__out PIDLIST_ABSOLUTE *ppidl)
{
  if (ppidl == NULL)
    return E_POINTER;

  *ppidl = 0;

  HRESULT hr = (m_ThisPidl ? S_OK : S_FALSE /*E_FAIL*/);
  if (NULL != m_ThisPidl)
  {
    *ppidl = ILClone(m_ThisPidl);
    hr = *ppidl ? S_OK : E_OUTOFMEMORY;
  }
  return hr;
}

HRESULT CArchiveFolder::InitializeOnBind(CArchiveFolder *ancestor, const szstring &relativePath, PCIDLIST_RELATIVE relativePidl)
{
  try
  {
    if (!ancestor->m_ThisPath.empty())
      m_ThisPath = Combine(ancestor->m_ThisPath, relativePath);
    else
      m_ThisPath = relativePath;

    if (0 != ancestor->m_ThisPidl)
      m_ThisPidl = ILCombine(ancestor->m_ThisPidl, relativePidl);
    else
      m_ThisPidl = ILClone(relativePidl);

    m_RootPath.assign(ancestor->m_RootPath);
    m_RootPidl = ILClone(ancestor->m_RootPidl);

    m_VolumeInfo = ancestor->m_VolumeInfo;
    m_Container = ancestor->m_Container->FindDescendant(relativePath);

    ATLASSERT(m_Container != 0);

    // TODO: 他にも初期化
  }
  catch (...)
  {
    return E_FAIL;
  }
  return (m_RootPidl != 0 && m_ThisPidl != 0) ? S_OK : E_OUTOFMEMORY;
}

void CArchiveFolder::DelayOpen()
{
  ATLASSERT(m_VolumeInfo.get() != 0);
  if (!m_VolumeInfo->Opened())
  {
    ATLASSERT(m_ThisPath.empty()); // 多分

    m_VolumeInfo->Open();
    m_Container = m_VolumeInfo->GetRootContainer();
  }
}

// IShellFolder::BindToObject
STDMETHODIMP CArchiveFolder::BindToObject(__in PCUIDLIST_RELATIVE pidl, __in IBindCtx *pbc, __in REFIID riid, __out void **ppv)
{
  *ppv = 0;

  if (riid != __uuidof(IShellFolder))
  {
    ATLTRACE2(atlTraceGeneral, 4, SZL("CArchiveFolder::BindToObject() called w/ non IShellFolder interface.\n"));
    return E_NOINTERFACE;
  }

  DelayOpen();

  CComObject<CArchiveFolder> *pSubFolder;
  HRESULT hr = CComObject<CArchiveFolder>::CreateInstance(&pSubFolder);
  if (FAILED(hr))
    return hr;

  pSubFolder->AddRef(); // ここで使う間だけ AddRef しておく

  szstring relativePath = RelativePidlToPath(pidl);
  hr = pSubFolder->InitializeOnBind(this, relativePath, pidl);
  if (SUCCEEDED(hr))
    hr = pSubFolder->QueryInterface(riid, ppv);

  pSubFolder->Release();

  return hr;
}

// IShellFolder::BindToStorage
STDMETHODIMP CArchiveFolder::BindToStorage(__in PCUIDLIST_RELATIVE pidl, __in IBindCtx *pbc, __in REFIID riid, __out void **ppv)
{
  return E_NOTIMPL;
}

// IShellFolder::CompareIDs
STDMETHODIMP CArchiveFolder::CompareIDs(__in LPARAM lParam, __in PCUIDLIST_RELATIVE pidl1, __in PCUIDLIST_RELATIVE pidl2)
{
  return lstrcmp((LPCTSTR)pidl1->mkid.abID, (LPCTSTR)pidl2->mkid.abID);
}

// IShellFolder::CreateViewObject
STDMETHODIMP CArchiveFolder::CreateViewObject(__in HWND hwndOwner, __in REFIID riid, __out void **ppv)
{
  if (ppv == 0)
    return E_POINTER;
  *ppv = 0;

  HRESULT hr = E_NOINTERFACE;

  if (riid == IID_IShellView)
  {
    SFV_CREATE csfv = { sizeof(csfv), 0, 0, 0 };
    hr = QueryInterface(IID_PPV_ARGS(&csfv.pshf));
    if (SUCCEEDED(hr))
    {
      csfv.psfvcb = 0;
      hr = SHCreateShellFolderView(&csfv, (IShellView **)ppv);
      csfv.pshf->Release();
    }
  }
  else if (riid == IID_ICategoryProvider)
  {
		//CArchiveCategorizerName *pCategorizer = new CArchiveCategorizerName(this);

		//// TODO: ちゃんと管理

		//pCategorizer->AddRef(); // ここで使う間だけ AddRef しておく
		//pCategorizer->QueryInterface(riid, ppv);


    //CFolderViewImplCategoryProvider* pCatProvider = new CFolderViewImplCategoryProvider(this);
    //hr = pCatProvider ? S_OK : E_OUTOFMEMORY;
    //if (SUCCEEDED(hr))
    //{ 
    //  hr = pCatProvider->QueryInterface(riid, ppv);
    //  pCatProvider->Release();
    //} 
  }
  else if (riid == IID_IContextMenu)
  {
    //DEFCONTEXTMENU dcm = { hwndOwner, NULL, m_ThisPidl, static_cast<IShellFolder2 *>(this), 0, NULL, NULL, 0, NULL };
    //hr = SHCreateDefaultContextMenu(&dcm, riid, ppv);
  }

  return hr;
}

// IShellFolder::EnumObjects
STDMETHODIMP CArchiveFolder::EnumObjects(__in HWND hwnd, __in SHCONTF grfFlags, __out IEnumIDList **ppenumIDList)
{
  if (0 == ppenumIDList)
    return E_POINTER;

  *ppenumIDList = 0;

  //// We can ask the user for something, using hwndOwner as our parent window, if necessary.
  //const bool canShowUI = (hwndOwner != 0);

  //// Check grfFlags to see what the shell wants to enumerate and how.
  const bool enumFolders = (0 != (grfFlags & SHCONTF_FOLDERS));
  const bool enumNonFolders = (0 != (grfFlags & SHCONTF_NONFOLDERS));
  //const bool lazyInit = (0 != (grfFlags & SHCONTF_INIT_ON_FIRST_NEXT));
  //const bool fastItems = (0 != (grfFlags & SHCONTF_FASTITEMS));
  //const bool flatLists = (0 != (grfFlags & SHCONTF_FLATLIST));
  //const bool async = (0 != (grfFlags & SHCONTF_ENABLE_ASYNC));

  DelayOpen();

  CComObject<CFolderEnumIDList> *penum;
  HRESULT hr = CComObject<CFolderEnumIDList>::CreateInstance(&penum);
  if (FAILED(hr))
    return hr;

  penum->AddRef(); // ここで使う間だけ AddRef しておく
  penum->Configure(enumFolders, enumNonFolders, m_Container);
  hr = penum->QueryInterface(IID_IEnumIDList, (void **)ppenumIDList);
  penum->Release();

  return hr;
}

// IShellFolder::GetAttributesOf
STDMETHODIMP CArchiveFolder::GetAttributesOf(__in UINT cidl, __in PCUITEMID_CHILD_ARRAY apidl, __inout SFGAOF *rgfInOut)
{
  DelayOpen();

  HRESULT hr = E_INVALIDARG;
  if (1 == cidl)
  {
    const szstring childName = ExtractName(apidl[0]);

    // TODO: 属性をちゃんと設定

    // 呼び出し側が知りたい属性が rgfInOut にセットされてくるので、あくまで | ではなくて & をすることに注意。
    StoredItemContainer *subContainer = m_Container->FindSubContainer(childName);
    if (0 != subContainer)
    {
      SFGAOF flag = SFGAO_BROWSABLE | SFGAO_FOLDER;
      if (subContainer->GetNumberOfSubContainers() > 0)
        flag |= SFGAO_HASSUBFOLDER;

      // 返したい属性を or した後で、一気に入力されたパラメータと and しないと要求されたフラグが消えてしまうので注意。
      *rgfInOut &= flag;
    }
    else
      *rgfInOut = 0;

    hr = S_OK;
  }
  return hr;
}

// IShellFolder::GetDisplayNameOf
STDMETHODIMP CArchiveFolder::GetDisplayNameOf(__in PCUITEMID_CHILD pidl, __in SHGDNF uFlags, __out STRRET *pName)
{
  // SHGDN_FORPARSING がセットされていて、かつ SHGDN_INFOLDER がセットされていない場合は、直下のアイテムだけでなく任意の子孫の名前が要求されることがある。
  // ※というか、昔そのような仕様だったことがある。今は必ず単一レベルの相対パスになっている。
  // いずれにせよ、マルチレベル相対パスの前提で処理すればよい。
  szstring name = RelativePidlToPath(pidl);
  pName->uType = STRRET_WSTR;
  pName->pOleStr = (LPWSTR)CoTaskMemAlloc((name.size() + 1) * sizeof(szchar));
  StringCchCopy(pName->pOleStr, name.size() + 1, name.c_str());
  return S_OK;
}

// IShellFolder::GetUIObjectOf
STDMETHODIMP CArchiveFolder::GetUIObjectOf(__in HWND hwndOwner, __in UINT cidl, __in PCUITEMID_CHILD_ARRAY apidl, __in REFIID riid, __reserved UINT *rgfReserved, __out void **ppv)
{
  *ppv = 0;
  HRESULT hr = E_NOINTERFACE;
  return hr;
}

// IShellFolder::ParseDisplayName
STDMETHODIMP CArchiveFolder::ParseDisplayName(__in HWND hwnd, __in IBindCtx *pbc, __in LPWSTR pszDisplayName, __out ULONG *pchEaten, __out PIDLIST_RELATIVE *ppidl, __inout ULONG *pdwAttributes)
{
  return E_NOTIMPL;
}

// IShellFolder::SetNameOf
STDMETHODIMP CArchiveFolder::SetNameOf(__in HWND hwnd, __in PCUITEMID_CHILD pidl, __in LPCWSTR pszName, __in SHGDNF uFlags, __out PITEMID_CHILD *ppidlOut)
{
  *ppidlOut = 0;
  return E_NOTIMPL;
}

// IShellFolder2::GetDefaultSearchGUID
STDMETHODIMP CArchiveFolder::GetDefaultSearchGUID(__out GUID *pguid)
{
  return E_NOTIMPL;
}

// IShellFolder2::EnumSearches
STDMETHODIMP CArchiveFolder::EnumSearches(__out IEnumExtraSearch **ppenum)
{
  *ppenum = 0;
  return E_NOINTERFACE;
}

// IShellFolder2::GetDefaultColumn
STDMETHODIMP CArchiveFolder::GetDefaultColumn(__in DWORD dwRes, __out ULONG *pSort, __out ULONG *pDisplay)
{
  *pSort = 0;
  *pDisplay = 0;
  return S_OK;
}

// IShellFolder2::GetDefaultColumnState
STDMETHODIMP CArchiveFolder::GetDefaultColumnState(__in UINT iColumn, __out SHCOLSTATEF *pcsFlags)
{
  HRESULT hr = (iColumn < 3) ? S_OK : E_INVALIDARG;
  if (SUCCEEDED(hr))
    *pcsFlags = SHCOLSTATE_ONBYDEFAULT | SHCOLSTATE_TYPE_STR;
  return hr;
}

// IShellFolder2::GetDetailsEx
STDMETHODIMP CArchiveFolder::GetDetailsEx(__in PCUITEMID_CHILD pidl, __in const SHCOLUMNID *pscid, __out VARIANT *pv)
{
  return E_NOTIMPL;
}

// IShellFolder2::GetDetailsOf
STDMETHODIMP CArchiveFolder::GetDetailsOf(__in PCUITEMID_CHILD pidl, __in UINT iColumn, __out SHELLDETAILS *psd)
{
  return E_NOTIMPL;
}

// IShellFolder2::MapColumnToSCID
STDMETHODIMP CArchiveFolder::MapColumnToSCID(__in UINT iColumn, __out SHCOLUMNID *pscid)
{
  return E_NOTIMPL;
}
